// SPB Weather template for rp5.ru weather site
// ver. 1.3 (16.08.2005) by Denis Dyomin (c) 2005
// e-mail: synochka@mail.ru
// special thanks to owlman and timoff

main
{
	// beginning of the weather area
	pointer weatherStart
	{
		go_start ; 
		skip_to_text ( "tname" , false ) ;
		skip_to_text ( "<tr" , false ) ;
	} ;
	// ending of the weather area
	pointer weatherEnd
	{
		skip_to_text ( "</table>" , false ) ;
	} ;
	
	// beginning of the main weather area
	pointer daysStart
	{
		go_start ;		
		skip_to_text ( " " , false ) ;
	} ;
	// ending of the main weather area
	pointer daysEnd
	{
		skip_to_text ( "</table>" , false ) ;
	} ;

	// mappings for wind direction
	map WindDirRusToEng
	{
		key_value ( "" , "S" ) ;
		key_value ( "" , "N" ) ;
		key_value ( "" , "W" ) ;
		key_value ( "" , "E" ) ;
		key_value ( "-" , "SE" ) ;
		key_value ( "-" , "SW" ) ;
		key_value ( "-" , "NE" ) ;
		key_value ( "-" , "NW" ) ;
	} ;

	// integer to string length mapping
	map IntToStr
	{
		key_value ( "1" , "a" ) ;
		key_value ( "2" , "aa" ) ;
		key_value ( "3" , "aaa" ) ;
		key_value ( "4" , "aaaa" ) ;
		key_value ( "5" , "aaaaa" ) ;
		key_value ( "6" , "aaaaaa" ) ;
	} ;

	// map for sky
	map SpbSky
	{
		// 0 NEBULOSITY
		key_value ( "d000" , "2" ) ;

		key_value ( "d011" , "14" ) ;
		key_value ( "d012" , "14" ) ;
		key_value ( "d013" , "14" ) ;
		key_value ( "d014" , "14" ) ;
		key_value ( "d015" , "14" ) ;
		key_value ( "d016" , "14" ) ;
		key_value ( "d017" , "14" ) ;
		key_value ( "d018" , "14" ) ;

		key_value ( "d021" , "16" ) ;
		key_value ( "d022" , "16" ) ;
		key_value ( "d023" , "16" ) ;
		key_value ( "d024" , "16" ) ;
		key_value ( "d025" , "16" ) ;
		key_value ( "d026" , "16" ) ;
		key_value ( "d027" , "16" ) ;
		key_value ( "d028" , "16" ) ;

		key_value ( "d031" , "16" ) ;
		key_value ( "d032" , "16" ) ;
		key_value ( "d033" , "16" ) ;
		key_value ( "d034" , "16" ) ;
		key_value ( "d035" , "16" ) ;
		key_value ( "d036" , "16" ) ;
		key_value ( "d037" , "16" ) ;
		key_value ( "d038" , "16" ) ;

		// 1 NEBULOSITY
		key_value ( "d100" , "3" ) ;

		key_value ( "d111" , "14" ) ;
		key_value ( "d112" , "14" ) ;
		key_value ( "d113" , "14" ) ;
		key_value ( "d114" , "14" ) ;
		key_value ( "d115" , "14" ) ;
		key_value ( "d116" , "14" ) ;
		key_value ( "d117" , "14" ) ;
		key_value ( "d118" , "14" ) ;

		key_value ( "d121" , "16" ) ;
		key_value ( "d122" , "16" ) ;
		key_value ( "d123" , "16" ) ;
		key_value ( "d124" , "16" ) ;
		key_value ( "d125" , "16" ) ;
		key_value ( "d126" , "16" ) ;
		key_value ( "d127" , "16" ) ;
		key_value ( "d128" , "16" ) ;

		key_value ( "d131" , "16" ) ;
		key_value ( "d132" , "16" ) ;
		key_value ( "d133" , "16" ) ;
		key_value ( "d134" , "16" ) ;
		key_value ( "d135" , "16" ) ;
		key_value ( "d136" , "16" ) ;
		key_value ( "d137" , "16" ) ;
		key_value ( "d138" , "16" ) ;
		
		// 2 NEBULOSITY
		key_value ( "d200" , "4" ) ;

		key_value ( "d211" , "7" ) ;
		key_value ( "d212" , "7" ) ;
		key_value ( "d213" , "7" ) ;
		key_value ( "d214" , "8" ) ;
		key_value ( "d215" , "8" ) ;
		key_value ( "d216" , "8" ) ;
		key_value ( "d217" , "8" ) ;
		key_value ( "d218" , "8" ) ;

		key_value ( "d221" , "9" ) ;
		key_value ( "d222" , "9" ) ;
		key_value ( "d223" , "9" ) ;
		key_value ( "d224" , "9" ) ;
		key_value ( "d225" , "9" ) ;
		key_value ( "d226" , "9" ) ;
		key_value ( "d227" , "9" ) ;
		key_value ( "d228" , "9" ) ;

		key_value ( "d231" , "10" ) ;
		key_value ( "d232" , "10" ) ;
		key_value ( "d233" , "10" ) ;
		key_value ( "d234" , "11" ) ;
		key_value ( "d235" , "11" ) ;
		key_value ( "d236" , "11" ) ;
		key_value ( "d237" , "11" ) ;
		key_value ( "d238" , "11" ) ;

		// 3 NEBULOSITY
		key_value ( "d300" , "4" ) ;

		key_value ( "d311" , "7" ) ;
		key_value ( "d312" , "7" ) ;
		key_value ( "d313" , "7" ) ;
		key_value ( "d314" , "8" ) ;
		key_value ( "d315" , "8" ) ;
		key_value ( "d316" , "8" ) ;
		key_value ( "d317" , "8" ) ;
		key_value ( "d318" , "8" ) ;

		key_value ( "d321" , "9" ) ;
		key_value ( "d322" , "9" ) ;
		key_value ( "d323" , "9" ) ;
		key_value ( "d324" , "9" ) ;
		key_value ( "d325" , "9" ) ;
		key_value ( "d326" , "9" ) ;
		key_value ( "d327" , "9" ) ;
		key_value ( "d328" , "9" ) ;

		key_value ( "d331" , "10" ) ;
		key_value ( "d332" , "10" ) ;
		key_value ( "d333" , "10" ) ;
		key_value ( "d334" , "11" ) ;
		key_value ( "d335" , "11" ) ;
		key_value ( "d336" , "11" ) ;
		key_value ( "d337" , "11" ) ;
		key_value ( "d338" , "11" ) ;
		
		// 4 NEBULOSITY
		key_value ( "d400" , "5" ) ;

		key_value ( "d411" , "7" ) ;
		key_value ( "d412" , "7" ) ;
		key_value ( "d413" , "7" ) ;
		key_value ( "d414" , "8" ) ;
		key_value ( "d415" , "8" ) ;
		key_value ( "d416" , "8" ) ;
		key_value ( "d417" , "8" ) ;
		key_value ( "d418" , "8" ) ;

		key_value ( "d421" , "9" ) ;
		key_value ( "d422" , "9" ) ;
		key_value ( "d423" , "9" ) ;
		key_value ( "d424" , "9" ) ;
		key_value ( "d425" , "9" ) ;
		key_value ( "d426" , "9" ) ;
		key_value ( "d427" , "9" ) ;
		key_value ( "d428" , "9" ) ;

		key_value ( "d431" , "10" ) ;
		key_value ( "d432" , "10" ) ;
		key_value ( "d433" , "10" ) ;
		key_value ( "d434" , "11" ) ;
		key_value ( "d435" , "11" ) ;
		key_value ( "d436" , "11" ) ;
		key_value ( "d437" , "11" ) ;
		key_value ( "d438" , "11" ) ;

		// 5 NEBULOSITY
		key_value ( "d500" , "5" ) ;

		key_value ( "d511" , "7" ) ;
		key_value ( "d512" , "7" ) ;
		key_value ( "d513" , "7" ) ;
		key_value ( "d514" , "8" ) ;
		key_value ( "d515" , "8" ) ;
		key_value ( "d516" , "8" ) ;
		key_value ( "d517" , "8" ) ;
		key_value ( "d518" , "8" ) ;

		key_value ( "d521" , "9" ) ;
		key_value ( "d522" , "9" ) ;
		key_value ( "d523" , "9" ) ;
		key_value ( "d524" , "9" ) ;
		key_value ( "d525" , "9" ) ;
		key_value ( "d526" , "9" ) ;
		key_value ( "d527" , "9" ) ;
		key_value ( "d528" , "9" ) ;

		key_value ( "d531" , "10" ) ;
		key_value ( "d532" , "10" ) ;
		key_value ( "d533" , "10" ) ;
		key_value ( "d534" , "11" ) ;
		key_value ( "d535" , "11" ) ;
		key_value ( "d536" , "11" ) ;
		key_value ( "d537" , "11" ) ;
		key_value ( "d538" , "11" ) ;
	} ;
	
	map DayToNightMap
	{
		key_value ( "2" , "17" ) ;
		key_value ( "3" , "18" ) ;
		key_value ( "4" , "19" ) ;
		key_value ( "5" , "20" ) ;
		key_value ( "7" , "21" ) ;
		key_value ( "8" , "22" ) ;
		key_value ( "9" , "23" ) ;
		key_value ( "10" , "24" ) ;
		key_value ( "11" , "25" ) ;
		key_value ( "14" , "28" ) ;
		key_value ( "16" , "30" ) ;
	} ;

	map OddToEvenMap
	{
		key_value ( "1" , "2" ) ;
		key_value ( "3" , "4" ) ;
		key_value ( "5" , "6" ) ;
		key_value ( "7" , "8" ) ;
	} ;

	map AverageMap
	{
		key_value ( "00" , "0" ) ;
		key_value ( "02" , "1" ) ;
		key_value ( "04" , "3" ) ;
		key_value ( "06" , "4" ) ;
		key_value ( "08" , "5" ) ;

		key_value ( "20" , "1" ) ;
		key_value ( "22" , "2" ) ;
		key_value ( "24" , "3" ) ;
		key_value ( "26" , "4" ) ;
		key_value ( "28" , "5" ) ;

		key_value ( "40" , "3" ) ;
		key_value ( "42" , "3" ) ;
		key_value ( "44" , "4" ) ;
		key_value ( "46" , "5" ) ;
		key_value ( "48" , "6" ) ;

		key_value ( "60" , "4" ) ;
		key_value ( "62" , "4" ) ;
		key_value ( "64" , "5" ) ;
		key_value ( "66" , "6" ) ;
		key_value ( "68" , "7" ) ;
		
		key_value ( "80" , "5" ) ;
		key_value ( "82" , "5" ) ;
		key_value ( "84" , "6" ) ;
		key_value ( "86" , "7" ) ;
		key_value ( "88" , "8" ) ;
	} ;

	map AverageTypeMap
	{
		key_value ( "00" , "0" ) ;
		key_value ( "01" , "1" ) ;
		key_value ( "02" , "2" ) ;
		key_value ( "03" , "3" ) ;

		key_value ( "10" , "1" ) ;
		key_value ( "11" , "1" ) ;
		key_value ( "12" , "2" ) ;
		key_value ( "13" , "2" ) ;

		key_value ( "20" , "2" ) ;
		key_value ( "21" , "2" ) ;
		key_value ( "22" , "2" ) ;
		key_value ( "23" , "3" ) ;

		key_value ( "30" , "3" ) ;
		key_value ( "31" , "2" ) ;
		key_value ( "32" , "3" ) ;
		key_value ( "33" , "3" ) ;
	} ;

	// UNCOMMENT NEXT LINE TO TURN ON DEBUG LOG!
	// debug_log ;
	// -----------------------------------------

	// URL - NN town code is 5797
	open_url ( "http://rp5.ru/town.php?id=" + CityCode + "&forprint=1" , "GET" ) ;

	// 6-day counter
	string Cntr = "" ;
	string S = "" ;
	string TotDayDataQty = "" ;
	while ( Cntr $ "aaaaaa" )
	{
		Cntr = Cntr + "a" ;

		// selecting weather area
		select_area ( weatherStart , weatherEnd ) ;

		// default day data
		string dayOfMonth = "" ;
		string hour = "" ;
		string sky = "0" ;
		string tmpr = "0" ;
		string tmprUnits = "C" ;
		string pressure = "0" ;
		string humidity = "0" ;
		string pressureUnits = "mm" ;
		string windSpeed = "0" ;
		string windSpeedUnits = "mps" ;
		string windDirection = "" ;
		
		// moving cursor to the beginning of the next "colspan" (day-data-qty)
		string DayCntr = "" ;
		while ( DayCntr $ Cntr )
		{
			DayCntr = DayCntr + "a" ;	
			skip_to_text ( "<td colspan=\"" , false ) ;
		} ;
		// day data quantity
		begin_var ;
		skip_chars ( "0-9" ) ;
		string DayDataQty = end_var ;
		DayDataQty = IntToStr [ DayDataQty ] ;
		// day name
		skip_to_text ( ">" , false ) ;
		begin_var ;
		skip_chars ( "0-9" ) ;
		string dayOfMonth = end_var ;
		
		// day information for all the hours (DayDataQty)
		string DayDataCntr = "" ;
		while ( DayDataCntr $ DayDataQty )
		{
			select_area ( daysStart , daysEnd ) ;
			// moving to hour info section of the day
			DayCntr = "" ;
			while ( DayCntr $ ( TotDayDataQty + DayDataCntr ) )
			{
				DayCntr = DayCntr + "a" ;
				skip_to_text ( "<td" , false ) ;
			} ;
			skip_to_text ( "<td" , false ) ;
			skip_to_text ( ">" , false ) ;
			begin_var ;
			skip_to_tags ;
			hour = end_var ;

			// nebulosity
			skip_to_text ( "<tr" , false ) ;
			skip_to_text ( "<td" , false ) ;
			skip_to_text ( "<td" , false ) ;
			DayCntr = "" ;
			while ( DayCntr $ ( TotDayDataQty + DayDataCntr ) )
			{
				DayCntr = DayCntr + "a" ;
				skip_to_text ( "<td" , false ) ;
			} ;
			skip_to_text ( "src=\"img/c" , false ) ;
			begin_var ;
			skip_to_chars ( "0-9" ) ;
			string DayOrNight = end_var ;
			// will always define sky for day - for night will use DayToNightMap
			sky = "d" ;
			begin_var ;
			skip_to_chars ( "." ) ;
			sky = sky + end_var ;
			
			// precipitation
			skip_to_text ( "<tr" , false ) ;
			skip_to_text ( "<td" , false ) ;
			skip_to_text ( "<td" , false ) ;
			DayCntr = "" ;
			while ( DayCntr $ ( TotDayDataQty + DayDataCntr ) )
			{
				DayCntr = DayCntr + "a" ;
				skip_to_text ( "<td" , false ) ;
			} ;

			skip_to_text ( "src=\"img/" , false ) ;
			begin_var ;
			skip_chars ( "0-9" ) ;
			string precipitation = end_var ;
			// default type and intensivity of precipitation
			string PrecType = "0" ;
			string PrecIntens = "0" ;
			// if there is some image will get type of precipitation and its intensivity
			// (o1[this is type virying from 1 to 3]d|n1[this is intensivity virying from 1 to 8])
			if (!precipitation)
			{
				// type
				skip_to_chars ( "0-9" ) ;
				begin_var ;
				skip_chars ( "0-9" ) ;
				PrecType = end_var ;
				// intensivity
				skip_to_chars ( "0-9" ) ;
				begin_var ;
				skip_chars ( "0-9" ) ;
				PrecIntens = end_var ;
				S = OddToEvenMap [ PrecIntens ] ;
				if ( S )
					PrecIntens = S ;
			} ;
			// checking for the second precipitation icon existance
			skip_to_text ( ">" , false ) ;
			begin_var ;
			skip_chars ( "<img" ) ;
			S = end_var ;
			if (  S ~ "<img" )
			{
				skip_to_text ( "src=\"img/" , false ) ;
				begin_var ;
				skip_chars ( "0-9" ) ;
				string precipitation = end_var ;
				// default type and intensivity of precipitation
				string PrecType2 = "0" ;
				string PrecIntens2 = "0" ;
				// if there is some image will get type of precipitation and its intensivity
				if (!precipitation)
				{
					// type
					skip_to_chars ( "0-9" ) ;
					begin_var ;
					skip_chars ( "0-9" ) ;
					PrecType2 = end_var ;
					// intensivity
					skip_to_chars ( "0-9" ) ;
					begin_var ;
					skip_chars ( "0-9" ) ;
					PrecIntens2 = end_var ;
					S = OddToEvenMap [ PrecIntens2 ] ;
					if ( S )
						PrecIntens2 = S ;
				} ;
				PrecType = AverageTypeMap [ PrecType + PrecType2 ] ;
				PrecIntens = AverageMap [ PrecIntens + PrecIntens2 ] ;
			} ;

			// calculated sky convertion to SPB format
			sky = sky + PrecType + PrecIntens ;
			sky = SpbSky [ sky ] ;
			if ( DayOrNight ~ "n" )
				sky = DayToNightMap [ sky ] ;

			// pressure
			skip_to_text ( "<tr" , false ) ;
			skip_to_text ( "<td" , false ) ;
			skip_to_text ( "<td" , false ) ;
			DayCntr = "" ;
			while ( DayCntr $ ( TotDayDataQty + DayDataCntr ) )
			{
				DayCntr = DayCntr + "a" ;
				skip_to_text ( "<td" , false ) ;
			} ;
			skip_to_text ( ">" , false ) ;
			begin_var ;
			skip_to_tags ;
			pressure = end_var ;
			
			// temp
			skip_to_text ( "<tr" , false ) ;
			skip_to_text ( "<td" , false ) ;
			skip_to_text ( "<td" , false ) ;
			DayCntr = "" ;
			while ( DayCntr $ ( TotDayDataQty + DayDataCntr ) )
			{
				DayCntr = DayCntr + "a" ;
				skip_to_text ( "<td" , false ) ;
			} ;
			skip_to_text ( ">" , false ) ;
			begin_var ;
			skip_to_tags ;
			tmpr = end_var ;
			
			// humidity
			skip_to_text ( "<tr" , false ) ;
			skip_to_text ( "<td" , false ) ;
			skip_to_text ( "<td" , false ) ;
			DayCntr = "" ;
			while ( DayCntr $ ( TotDayDataQty + DayDataCntr ) )
			{
				DayCntr = DayCntr + "a" ;
				skip_to_text ( "<td" , false ) ;
			} ;
			skip_to_text ( ">" , false ) ;
			begin_var ;
			skip_chars ( "0-9" ) ;
			humidity = end_var ;
			
			// wind info
			skip_to_text ( "<tr" , false ) ;
			skip_to_text ( "<td" , false ) ;
			skip_to_text ( "<td" , false ) ;
			DayCntr = "" ;
			while ( DayCntr $ ( TotDayDataQty + DayDataCntr ) )
			{
				DayCntr = DayCntr + "a" ;
				skip_to_text ( "<td" , false ) ;
			} ;
			skip_to_text ( ">" , false ) ;
			begin_var ;
			skip_to_tags ;
			windDirection = end_var ;
			windDirection = WindDirRusToEng [ windDirection ] ;
			skip_to_text ( "<br>" , false ) ;
			begin_var ;
			skip_chars ( "0-9" ) ;
			windSpeed = end_var ;

			if (tmpr)
				add_day ;
			DayDataCntr = DayDataCntr + "a" ;			
		} ;	
		TotDayDataQty = TotDayDataQty + DayDataQty ;		
	} ;

}